org 100h
ITERS equ 3
BASECOLOR equ 10

  mov  al,12h   ; mode 640x480x16
  int  10h
  push 0A000h
  pop  es
  fninit

M:
  mov  dx,16
U:mov  cx,16

E:
V:call S   ; generate point(cx,dx) on sphere, store to (bx di)
  mov  si,bx
  mov  bp,di

  inc  dx
  call S
  dec  dx
  
  pusha
  call L   ; draw line from (bx*64,di*64) to (cx,bp)
  popa
  inc  cx
  call S
  dec  cx
  call L

  add  dword[T],44
  xor  byte[COL],BASECOLOR
  jnz  E
  sub  dword[T],88

  loop V
  dec  dx
  jnz  U
  
  add  dword[T],44

  mov  dx,3DAh
W:in   al,dx
  and  al,8
  jz   W

  in   al,60h
  cmp  al,1
  jnz  M
  
  ret
  
; generate point(cx,dx) on sphere, store to bx di

             ;       -2 4  6  8  10                 12 14 16
S:pusha      ; push: ax cx dx bx sp(original value) bp si di
  xor  bx,bx
  fild  word[bx-2-2-4] ; a           ; saved cx
  fmul  dword[RR]
  fsincos              ; ca sa
  fld   st0            ; ca ca sa
  fild  word[bx-2-2-6] ; B ca ca sa  ; saved dx
  fmul  dword[RR]
  fiadd word[T]        ; b=B+t
  fsincos              ; cb sb ca ca sa
  fmulp st2,st0        ; sb ca*cb ca sa
  fmulp st2,st0        ; z=ca*cb y=ca*sb x=sa
             ; z y x
  fld   st0  ; z z y x
  fld   st3  ; x z z y x
  fild  dword[T]
  fcos
  fisub dword[T]
  fsincos       ; c s x z z y x
  fmul  st2,st0 ; c s cx z z y x
  fmulp st3,st0 ; s cx cz z y x
  fmul  st3,st0 ; s cx cz sz y x
  fmulp st5,st0 ; cx cz sz y sx
  faddp st2,st0 ; cz cx+sz y sx
  fsubp st3,st0 ; cx+sz y -sx+cx
  
  fiadd word[DEPTH]  ; Z=ca*cb+D y x
  fidivr word[ZOOM]   ; zoom/Z y x
  fmul  st1,st0    
  fmulp st2,st0    ; y/Z*zoom x/Z*zoom
  fistp word[bx-2-2-8]  ; saved di
  fistp word[bx-2-2-16] ; saved bx
  popa
  ret
  
; draw line from (bx>>S,di>>S) to (si>>S,bp>>S)
L:pusha
  sub  si,bx  ;dx
  sub  bp,di  ;dy

;  mov  cx,1
;H:sar  si,ITERS  
;  sar  bp,ITERS
;  shl  cx,ITERS

;  mov  cx,1
;H:sar  si,1
;  sar  bp,1
;  shl  cl,1  ; number of iters
;  imul ax,si,127; shift again if abs(bp) or abs(si) > 512
;  jo   H
;  imul ax,bp,127
;  jo   H

  mov  cx,si
  mov  ax,bp
H:neg  cx
  js   H
I:neg  ax
  js   I
  cmp  ax,cx
  jb   J
  xchg ax,cx
J:shr  cx,7
  inc  cx
  xchg ax,si
  cwd
  idiv cx
  xchg ax,si
  xchg ax,bp
  cwd
  idiv cx
  xchg ax,bp

;  mov  cx,si
;  mov  ax,bp
;H:neg  cx
;  js   H
;I:neg  ax
;  js   I
;  add  cx,ax
;J:shr  cx,9
;  inc  cx
;  xchg ax,si
;  cwd
;  idiv cx
;  xchg ax,si
;  xchg ax,bp
;  cwd
;  idiv cx
;  xchg ax,bp

X:pusha  ; bx=x*16 di=y*16 al=color   (10.6)

  sar  bx,6
  mov  cl,bl      ; cl = x
  sar  bx,3 

  sar  di,6
  imul di,80      ; offset = y*(w/8) + x/8
  
  mov  dx,3CEh    ; video hardware controller
  mov  ax,0x8008
  ror  ah,cl      ; 0xMM08, MM = 0x80>>(x&7)
  out  dx,ax
  mov  ax,0x0205  ; read mode 0, write mode 2
  out  dx,ax
  
  mov  ah,0
COL equ $-1
  xchg byte[es:bx+di+(240*640 + 320)/8],ah; load to latch, write to register
F:popa
  
  add  bx,si ; advance
  add  di,bp
N:loop X
  popa
  ret


ZOOM  dw 20000
DEPTH dw 2
RR dd 0.392699081698724154807830422909938 ; 2*pi/16

section .bss
T resd 1
